/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BiomeColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;

public interface RegionShader {
    public static final RegionShader[] DEFAULT_SHADERS = new RegionShader[]{new FlatShader(), new ReliefShader(), new BiomeShader(), new HeightShader()};

    public void shade(Color[] var1, int[] var2, String[] var3, BiomeColorMap var4);

    public static class FlatShader
    implements RegionShader {
        @Override
        public void shade(Color[] map, int[] height, String[] biome, BiomeColorMap biomeColors) {
        }

        public int hashCode() {
            return Objects.hash(this.getClass().getName());
        }
    }

    public static class ReliefShader
    implements RegionShader {
        @Override
        public void shade(Color[] map, int[] height, String[] biome, BiomeColorMap biomeColors) {
            for (int z = 0; z < 512; ++z) {
                for (int x = 0; x < 512; ++x) {
                    if (map[z << 9 | x] == null) continue;
                    int centerHeight = height[z << 9 | x];
                    int westHeight = height[z << 9 | Math.max(x - 1, 0)];
                    int eastHeight = height[z << 9 | Math.min(x + 1, 511)];
                    int northHeight = height[Math.max(z - 1, 0) << 9 | x];
                    int southHeight = height[Math.min(z + 1, 511) << 9 | x];
                    int northWestHeight = height[Math.max(z - 1, 0) << 9 | Math.max(x - 1, 0)];
                    int northEastHeight = height[Math.max(z - 1, 0) << 9 | Math.min(x + 1, 511)];
                    int southWestHeight = height[Math.min(z + 1, 511) << 9 | Math.max(x - 1, 0)];
                    int southEastHeight = height[Math.min(z + 1, 511) << 9 | Math.min(x + 1, 511)];
                    double gX = northWestHeight * 1 + 2 * westHeight + southWestHeight * 1 - eastHeight * 1 - 2 * northEastHeight - southEastHeight * 1;
                    double gY = northWestHeight * 1 + 2 * northHeight + northEastHeight * 1 - southWestHeight * 1 - 2 * southHeight - southEastHeight * 1;
                    double g = Math.sqrt(gX * gX + gY * gY);
                    double factor = -Math.tanh((gX + gY) / 10.0);
                    map[z << 9 | x] = Color.shade(map[z << 9 | x], (float)(factor *= 0.3));
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.getClass().getName());
        }
    }

    public static class BiomeShader
    implements RegionShader {
        @Override
        public void shade(Color[] map, int[] height, String[] biome, BiomeColorMap biomeColors) {
            for (int z = 0; z < 512; ++z) {
                for (int x = 0; x < 512; ++x) {
                    int index = z << 9 | x;
                    if (map[index] == null || biome[index] == null) continue;
                    int westHeight = height[z << 9 | Math.max(x - 1, 0)];
                    int eastHeight = height[z << 9 | Math.min(x + 1, 511)];
                    int northHeight = height[Math.max(z - 1, 0) << 9 | x];
                    int southHeight = height[Math.min(z + 1, 511) << 9 | x];
                    int northWestHeight = height[Math.max(z - 1, 0) << 9 | Math.max(x - 1, 0)];
                    int northEastHeight = height[Math.max(z - 1, 0) << 9 | Math.min(x + 1, 511)];
                    int southWestHeight = height[Math.min(z + 1, 511) << 9 | Math.max(x - 1, 0)];
                    int southEastHeight = height[Math.min(z + 1, 511) << 9 | Math.min(x + 1, 511)];
                    double gX = northWestHeight * 1 + 2 * westHeight + southWestHeight * 1 - eastHeight * 1 - 2 * northEastHeight - southEastHeight * 1;
                    double gY = northWestHeight * 1 + 2 * northHeight + northEastHeight * 1 - southWestHeight * 1 - 2 * southHeight - southEastHeight * 1;
                    double factor = -Math.tanh((gX + gY) / 10.0);
                    map[index] = Color.shade(biomeColors.getBiomeColor((String)biome[index]).biomeColor, (float)(factor *= 0.3));
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.getClass().getName());
        }
    }

    public static class HeightShader
    implements RegionShader {
        private static final Color[] colors = (Color[])BlockColorMap.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(HeightShader.class.getResourceAsStream("/heightmap.json"))), Color[].class);

        @Override
        public void shade(Color[] map, int[] height, String[] biome, BiomeColorMap biomeColors) {
            for (int z = 0; z < 512; ++z) {
                for (int x = 0; x < 512; ++x) {
                    int index = z << 9 | x;
                    if (map[index] == null) continue;
                    int westHeight = height[z << 9 | Math.max(x - 1, 0)];
                    int eastHeight = height[z << 9 | Math.min(x + 1, 511)];
                    int northHeight = height[Math.max(z - 1, 0) << 9 | x];
                    int southHeight = height[Math.min(z + 1, 511) << 9 | x];
                    int northWestHeight = height[Math.max(z - 1, 0) << 9 | Math.max(x - 1, 0)];
                    int northEastHeight = height[Math.max(z - 1, 0) << 9 | Math.min(x + 1, 511)];
                    int southWestHeight = height[Math.min(z + 1, 511) << 9 | Math.max(x - 1, 0)];
                    int southEastHeight = height[Math.min(z + 1, 511) << 9 | Math.min(x + 1, 511)];
                    double gX = northWestHeight * 1 + 2 * westHeight + southWestHeight * 1 - eastHeight * 1 - 2 * northEastHeight - southEastHeight * 1;
                    double gY = northWestHeight * 1 + 2 * northHeight + northEastHeight * 1 - southWestHeight * 1 - 2 * southHeight - southEastHeight * 1;
                    double factor = -Math.tanh((gX + gY) / 10.0);
                    map[index] = Color.shade(colors[height[index] + 64], (float)(factor *= 0.3));
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.getClass().getName());
        }
    }

    public static enum DefaultShader {
        FLAT,
        RELIEF,
        BIOMES,
        HEIGHTMAP;


        public RegionShader getShader() {
            return DEFAULT_SHADERS[this.ordinal()];
        }
    }
}

